/*
 * Handle client switch maintenance requests
 */
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "libfma.h"
#include "lf_fms_comm.h"
#include "lf_channel.h"
#include "lf_fabric.h"

#include "fms.h"
#include "fms_error.h"
#include "fms_fabric.h"
#include "fms_client.h"

/*
 * Handle a switch maintenance request
 */
void
fms_client_switch_maintenance(
  struct fms_client_desc *cdp)
{
  struct fms_switch_maintenance *msg;
  struct lf_fms_return_code reply;
  struct lf_enclosure *ep;
  struct lf_fabric *fp;
  struct lf_linecard *lp;
  int slot;
  int port_label;
  int rc;

  fp = F.fabvars->fabric;

  /* get a pointer to the message */
  msg = &(cdp->cl_msgbuf->switch_maintenance);

  /* find the enclosure */
  ep = lf_find_enclosure_by_name(fp, msg->enc_name);
  if (ep == NULL) {
    strcpy(reply.reason, "No such enclosure");
    goto error;
  }

  /* Validate slot number */
  slot = msg->slot - ep->lc_slotbase;
  if (slot < 0 || slot >= ep->num_lc_slots) {
    strcpy(reply.reason, "Invalid slot number");
    goto error;
  }

  /* make sure a linecardis present in that slot */
  lp = ep->slots[slot];
  if (lp == NULL) {
    strcpy(reply.reason, "No linecard in specified slot");
    goto error;
  }

  /* Can't specify port on linecard with no transceivers */
  port_label = msg->port_label;
  if (port_label != -1 && lp->num_xcvrs == 0) {
    strcpy(reply.reason, "Cannot specify port on linecard with no ports");
    goto error;
  }

  /* put the linecard in maintenance mode */
  rc = fms_linecard_maintence(lp, port_label, msg->up);
  if (rc == -1) {
    fms_error_copy(reply.reason);
    goto error;
  }

  reply.fms_rc_32 = htonl(0);
  goto done;

 error:
  reply.fms_rc_32 = htonl(-1);

 done:
  /* send status reply */
  rc = send(cdp->chp->fd, &reply, sizeof(reply), 0);
  if (rc != sizeof(reply)) LF_ERROR(("Error sending return code to client"));

  if (ntohl(reply.fms_rc_32) != 0) {
    LF_ERROR(("Switch maintenance request failed with \"%s\"", reply.reason));
  }

  return;

 except:
  fms_perror();
}
